using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace SimpleEcoWebDemo
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class OrderForm : System.Web.UI.Page
	{
		protected Borland.Eco.Handles.ReferenceHandle rhRoot;
// ToDo replace Borland.Eco.Handles.EcoSpace with actual type of ecospace in project
		private Borland.Eco.Handles.EcoSpace ecoSpace;
		protected Borland.Eco.Handles.ExpressionHandle ehItems;
		protected System.Web.UI.WebControls.TextBox tbCustomer;
		protected System.Web.UI.WebControls.Label label1;
		protected System.Web.UI.WebControls.Label label2;
		protected System.Web.UI.WebControls.Label label3;
		protected System.Web.UI.WebControls.TextBox tbShipTo;
		protected System.Web.UI.WebControls.TextBox tbBillTo;
		protected System.Web.UI.WebControls.DataGrid dataGrid1;
		protected System.Web.UI.WebControls.Button btNewItem;
		protected System.Web.UI.WebControls.Button button1;
		protected System.Web.UI.WebControls.LinkButton linkButton1;
		protected System.Web.UI.WebControls.Label label4;
		protected System.Web.UI.WebControls.Label label5;
		protected Borland.Eco.Handles.ExpressionHandle ehOrderTotal;
		protected Borland.Eco.Handles.EcoSpace EcoSpace
		{
			get
			{
				if (ecoSpace == null)
				{
					ecoSpace = EcoSpaceProvider.GetEcoSpace();
					rhRoot.EcoSpace = ecoSpace;
				}
				return ecoSpace;
			}
		}

		private void DoneWithEcoSpace()
		{
			if (ecoSpace == null)
				return;
			rhRoot.EcoSpace = null;
			rhRoot.SetElement(null);
			// Clear all other references to ecoSpace or it's contents here.
			// Otherwise it is not safe to return it to a pool.

			EcoSpaceProvider.ReturnEcoSpace(ecoSpace);
			ecoSpace = null;
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			EcoSpace.Active = true;
			string Id = Request.Params["RootId"];
			if ((Id != null) && (Id != ""))
				rhRoot.SetElement(ObjectForId(Id));
			if (!IsPostBack)
				DataBind();
			// Put user code to initialize the page here
		}

		private void Page_Unload(object sender, System.EventArgs e)
		{
			DoneWithEcoSpace();
		}

		public override void DataBind()
		{
			ElementHandle.EnsureAllBindingLists();
			base.DataBind();
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// Required for Web Form Designer support
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.Column column11 = new Borland.Eco.Handles.Column();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.ehItems = new Borland.Eco.Handles.ExpressionHandle();
			this.ehOrderTotal = new Borland.Eco.Handles.ExpressionHandle();
			this.dataGrid1.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid_CancelCommand);
			this.dataGrid1.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid_EditCommand);
			this.dataGrid1.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid_UpdateCommand);
			this.dataGrid1.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid_DeleteCommand);
			this.btNewItem.Click += new System.EventHandler(this.btNewItem_Click);
			this.button1.Click += new System.EventHandler(this.button1_Click);
			this.linkButton1.Click += new System.EventHandler(this.linkButton1_Click);
			//
			// rhRoot
			//
			this.rhRoot.AddDefaultNestings = false;
			this.rhRoot.AddDefaultProperties = true;
			this.rhRoot.AddExternalId = true;
			this.rhRoot.EcoSpace = null;
			this.rhRoot.EcoSpaceType = typeof(SimpleEcoWebDemo.SimpleEcoWebDemoEcoSpace);
			this.rhRoot.StaticValueTypeName = "Order";
			this.rhRoot.Variables = null;
			//
			// ehItems
			//
			this.ehItems.AddDefaultNestings = false;
			this.ehItems.AddDefaultProperties = true;
			this.ehItems.AddExternalId = true;
			this.ehItems.AddRootVariables = false;
			column11.EventDerivedValue = false;
			column11.Expression = "self.Price*Quantity";
			column11.Name = "Total";
			column11.Nested = false;
			column11.NestingName = "";
			this.ehItems.Columns.AddRange(new Borland.Eco.Handles.Column[] {
						column11});
			this.ehItems.Expression = "self.OrderItem";
			this.ehItems.RootHandle = this.rhRoot;
			this.ehItems.Variables = null;
			//
			// ehOrderTotal
			//
			this.ehOrderTotal.AddDefaultNestings = false;
			this.ehOrderTotal.AddDefaultProperties = true;
			this.ehOrderTotal.AddExternalId = false;
			this.ehOrderTotal.AddRootVariables = false;
			this.ehOrderTotal.Expression = "self.OrderItem->collect(Price*Quantity)->sum";
			this.ehOrderTotal.RootHandle = this.rhRoot;
			this.ehOrderTotal.Variables = null;
			this.Unload += new System.EventHandler(this.Page_Unload);
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion

		#region Utility methods
		protected void UpdateDatabase()
		{
			IPersistenceService persistenceService = EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			IDirtyListService dirtyListService = EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
			persistenceService.UpdateDatabaseWithList(dirtyListService.AllDirtyObjects());
		}

		protected string IdForObject(IObject obj)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.IdForObject(obj);
		}

		protected IObject ObjectForId(string id)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.ObjectForId(id);
		}
		#endregion

		#region DataGrid support routines

		/*
		The following code is useful if the form contains a System.Web.UI.Datagrid;
		It assumes that the elementhandle acting as a datasource has
		AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"
		*/

		private void DataGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();
			IObject toDelete = ObjectForId(id);
			if (toDelete != null)
				toDelete.Delete();
			UpdateDatabase();
			DataBind();
		}

		private void DataGrid_EditCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = e.Item.ItemIndex;
			DataBind();
		}

		private void DataGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();
			dataGrid.DataBind(); // To get DataSource
			ElementHandle eh = (ElementHandle)dataGrid.DataSource;
			object row = eh.RenderElement(ObjectForId(id));
			for (int colIndex = 0; colIndex <  dataGrid.Columns.Count; colIndex++)
			{
				BoundColumn col = dataGrid.Columns[colIndex] as BoundColumn;
				if ((col != null) && !col.ReadOnly)
					eh.SetRenderedElementProperty(row, col.DataField, ((TextBox)e.Item.Cells[colIndex].Controls[0]).Text, true);
			}
			UpdateDatabase();
			dataGrid.EditItemIndex = -1;
			DataBind();
		}

		private void DataGrid_CancelCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = -1;
			DataBind();
		}
		#endregion

		// Show three different ways of putting back value

		private void btNewItem_Click(object sender, System.EventArgs e)
		{
			OrderItem oi = new OrderItem(EcoSpace);
			oi.Order = rhRoot.Element.AsObject as Order;
			UpdateDatabase();
			DataBind();
		}

		private void linkButton1_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("MainForm.aspx");
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			// Show three different ways of putting back value
			(rhRoot.Element.AsObject as Order).Customer = tbCustomer.Text;
			rhRoot.SetRenderedElementProperty(rhRoot.GetList()[0], "BillingAddress", tbBillTo.Text, true);
			(rhRoot.Element as IObject).Properties["ShippingAddress"].AsObject
				= tbShipTo.Text;
			UpdateDatabase();
			DataBind();
		}
	}
}
